/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.tn3270e;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.eui.HexInputRO;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.ResourceBundle;

public class Tn3270eAddressInputRO
extends Panel
implements JDMInput {
    private static final int RASID = 19;
    private static final int RASSUB = 1041;
    private static String Type_none = "None";
    private static String Type_IPV4 = "IPV4";
    private static String Type_IPV6 = "IPV6";
    private static final String Type_Invalid = "Invalid";
    private static final int Type_none_index = 0;
    private static final int Type_IPV4_index = 1;
    private static final int Type_IPV6_index = 2;
    private static String[] Tn3270eAddressTypes = new String[]{Type_none, Type_IPV4, Type_IPV6};
    private static final String NlsBundleName = "ibm.nways.tn3270e.Tn3270eAddressResources";
    private static ResourceBundle nlsResources = null;
    protected Label typeLabel;
    protected StringInputRO typeValue;
    protected int typeIndex = 0;
    protected Label ipV6Label;
    protected HexInputRO ipV6Value;
    protected Label ipV4Label;
    protected StringInputRO ipV4Value;

    public Tn3270eAddressInputRO() {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "Tn3270eAddressInputRO");
        }
        this.typeLabel = new Label(Tn3270eAddressInputRO.getNLSString("TypeLabel"));
        this.typeValue = new StringInputRO("");
        this.ipV6Label = new Label(Tn3270eAddressInputRO.getNLSString("IPV6Label"));
        this.ipV6Value = new HexInputRO();
        this.ipV4Label = new Label(Tn3270eAddressInputRO.getNLSString("IPV4Label"));
        this.ipV4Value = new StringInputRO("");
        this.typeLabel.setForeground(JmaColors.textText);
        this.ipV6Label.setForeground(JmaColors.textText);
        this.ipV4Label.setForeground(JmaColors.textText);
        this.typeValue.setForeground(JmaColors.textText);
        this.ipV6Value.setForeground(JmaColors.textText);
        this.ipV4Value.setForeground(JmaColors.textText);
        this.typeValue.setBackground(JmaColors.background);
        this.ipV6Value.setBackground(JmaColors.background);
        this.ipV4Value.setBackground(JmaColors.background);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.typeLabel, gridBagConstraints);
        gridBagLayout.setConstraints(this.ipV6Label, gridBagConstraints);
        gridBagLayout.setConstraints(this.ipV4Label, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = -1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagLayout.setConstraints((Component)this.typeValue, gridBagConstraints2);
        gridBagLayout.setConstraints((Component)this.ipV6Value, gridBagConstraints2);
        gridBagLayout.setConstraints((Component)this.ipV4Value, gridBagConstraints2);
        this.add(this.typeLabel);
        this.add((Component)this.typeValue);
        this.add(this.ipV6Label);
        this.add((Component)this.ipV6Value);
        this.add(this.ipV4Label);
        this.add((Component)this.ipV4Value);
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "Tn3270eAddressInputRO");
        }
    }

    public void setValue(Object object) {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "setValue");
        }
        if (object instanceof OctetString) {
            this.parseInput((OctetString)object);
        } else {
            this.setErrorValue(object.toString());
        }
        this.invalidate();
        Tn3270eAddressInputRO tn3270eAddressInputRO = this;
        Container container = tn3270eAddressInputRO.getParent();
        if (RAS.isEnabled(19, 1041)) {
            RAS.trace(19, 1041, this, "setValue", "Classes: " + this.getClass() + ',' + tn3270eAddressInputRO.getClass() + ',' + container.getClass());
        }
        container.validate();
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "setValue");
        }
    }

    public void setValue(String string) {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "setValue(String)");
        }
        try {
            OctetString octetString = new OctetString(string);
            this.setValue(octetString);
        }
        catch (Exception exception) {
            this.setErrorValue(string.toString());
        }
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "setValue(String)");
        }
    }

    public Object getValue() {
        return null;
    }

    public String toString() {
        return String.valueOf(this.typeValue.toString()) + ":" + this.ipV6Value.toString() + ":" + this.ipV4Value.toString();
    }

    public boolean isValidValue() {
        return true;
    }

    public boolean ignoreValue() {
        return false;
    }

    private void setErrorValue(String string) {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "ignoreValue");
        }
        this.typeValue.setText(Tn3270eAddressInputRO.getNLSString(Type_Invalid));
        this.ipV6Value.setValue(string);
        this.ipV4Value.setValue("");
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "ignoreValue");
        }
    }

    private void parseInput(OctetString octetString) {
        if (RAS.isEnabled(19, 1041)) {
            RAS.enter(19, 1041, this, "parseInput");
        }
        if (octetString.toString().equals("")) {
            this.typeValue.setText(Tn3270eAddressInputRO.getNLSString(Type_none));
            this.ipV6Value.setValue("");
            this.ipV4Value.setValue("");
        } else if (octetString.value.length == 4) {
            this.typeValue.setText(Tn3270eAddressInputRO.getNLSString(Type_IPV4));
            this.ipV6Value.setValue("");
            IPAddress iPAddress = new IPAddress(octetString.value, 0);
            this.ipV4Value.setValue((Object)iPAddress);
            if (RAS.isEnabled(19, 1041)) {
                RAS.trace(19, 1041, this, "parseInput", "IPV4: ipAddress= " + iPAddress);
                RAS.trace(19, 1041, this, "parseInput", "IPV4: type,IPV6,IPV4= " + this.typeIndex + " , " + octetString.toString());
            }
            this.ipV4Value.invalidate();
            this.ipV4Value.repaint();
        } else if (octetString.value.length == 16) {
            this.typeValue.setText(Tn3270eAddressInputRO.getNLSString(Type_IPV6));
            String string = octetString.toString().substring(0, 24);
            this.ipV6Value.setValue((Object)new OctetString(string));
            IPAddress iPAddress = new IPAddress(octetString.value, 12);
            this.ipV4Value.setValue((Object)iPAddress);
        } else {
            this.setErrorValue(octetString.toString());
        }
        if (RAS.isEnabled(19, 1041)) {
            RAS.exit(19, 1041, this, "parseInput");
        }
    }

    protected static String getNLSString(String string) {
        try {
            if (nlsResources == null) {
                nlsResources = ResourceBundle.getBundle(NlsBundleName);
            }
            if (nlsResources == null) {
                return string;
            }
            return nlsResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

